﻿using System;
using System.ComponentModel;
using System.Web.UI.WebControls;

namespace Framework.Web.UI
{
    /// <summary>
    /// ButtonFieldの機能拡張版
    /// </summary>
    public class LButtonField : System.Web.UI.WebControls.ButtonField
    {
        /// <summary>
        /// 確認ダイアログのメッセージキー
        /// </summary>
        public string ConfirmLTextKey { get; set; }

        /// <summary>
        /// ボタンに表示するテキストのテキストキー
        /// </summary>
        public string ButtonLTextKey { get; set; }

        /// <summary>
        /// ヘッダに表示するテキストのテキストキー
        /// </summary>
        public string HeaderLTextKey { get; set; }

        /// <summary>
        /// Initialize
        /// </summary>
        /// <param name="sortingEnabled"></param>
        /// <param name="control"></param>
        /// <returns></returns>
        public override bool Initialize(bool sortingEnabled, System.Web.UI.Control control)
        {
            //ローカライズ
            if (this.HeaderLTextKey.IsNotEmpty())
            {
                base.HeaderText = LTextMgr.GetText(this.HeaderLTextKey);
            }

            if (this.ButtonLTextKey.IsNotEmpty())
            {
                base.Text =LTextMgr.GetText(this.ButtonLTextKey);
            }

            return base.Initialize(sortingEnabled, control);
        }

        /// <summary>
        /// InitializeCell
        /// </summary>
        /// <param name="cell"></param>
        /// <param name="cellType"></param>
        /// <param name="rowState"></param>
        /// <param name="rowIndex"></param>
        public override void InitializeCell(DataControlFieldCell cell, DataControlCellType cellType, DataControlRowState rowState, int rowIndex)
        {
            base.InitializeCell(cell, cellType, rowState, rowIndex);

            //確認ダイアログを登録する
            if (this.ConfirmLTextKey.IsNotEmpty() && cellType == DataControlCellType.DataCell && cell.Controls.Count > 0)
            {
                var btn = cell.Controls[0] as WebControl;
                if (btn != null)
                {
                    JavaScript.RegisterConfirm(btn, LTextMgr.GetText(this.ConfirmLTextKey));
                }
            }
        }
    }
}
